import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="mhcii_netmhcii_2_3_percentile_data",
    version="1.0.1",
    packages=['mhcii_netmhcii_2_3_percentile_data' ],
    package_data={
        'mhcii_netmhcii_2_3_percentile_data': [
            'nn_align_percentile_distribution_2019-08-06.p',
            'requirements.txt'
        ],
    },
    test_suite = 'tests',
    description='PyPA package to provide template for python packaging.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
