

import pkg_resources
import pickle

package_name = 'mhcii_netmhciipan_4_1_el_percentile_data'
pickle_foldername = 'netmhciipan_percentile_distribution'
method_name = 'netmhciipan_el'
class PercentileManager(object):
    ''' Provides access to percentile score distributions
        taking care of storage specifics.
    '''

    def get_distributions(self, allele):
        ''' Returns percentile distributions for the given allele.
            pickle file name example:
            netmhciipan_percentile_distribution/netmhciipan_el_HLA-DQA10108-DQB10637.p
            netmhciipan_percentile_distribution/netmhciipan_el_DRB1_1135.p
        '''
        pickle_filename = '%s/%s_%s.p' % (pickle_foldername, method_name, allele)
        pickle_filepath = pkg_resources.resource_filename(package_name, pickle_filename)
        with open(pickle_filepath, 'rb') as pfile:
            score_distributions = pickle.load(pfile)
        return score_distributions

percentile_manager = PercentileManager()
