from pkg_resources import resource_filename #@UnresolvedImport
import pickle

package_name = 'mhcii_smmalign_percentile_data'
pickle_filename = 'smmalign_percentile_distribution_2019-04-19.p'
pickle_filepath = resource_filename(package_name, pickle_filename)

class PercentileManager(object):
    ''' | *brief*: Provides access to percentile score distributions
        |     taking care of storage specifics.
        | *author*: Jivan
        | *created*: 2016-01-27
    '''
    def __init__(self):
        with open(pickle_filepath,'rb') as pfile:
            self.score_distributions = pickle.load(pfile)

    def get_distributions(self, allele):
        ''' | *brief*: Returns percentile distributions for the given allele.
            | *author*: Jivan
            | *created*: 2016-01-27
        '''
        return self.score_distributions

percentile_manager = PercentileManager()
