import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name = "mhcii_tepitope_percentile_data",
    version = "2.0.1",
    packages = ['mhcii_tepitope_percentile_data' ],
    package_data = { 
        'mhcii_tepitope_percentile_data': [
            'tepitope_percentile_distribution_2018-11-21.p',
            'requirements.txt'
        ],
    },
    description = 'PyPA package to provide template for python packaging.',
    long_description = README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers = [
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
