'''update version to 1.0 for Python3 migration'''
import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="mhcii_tepitope_predictor",
    version="1.0.0",
    packages=['mhcii_tepitope_predictor' ],
    package_data={
        'mhcii_tepitope_predictor': [
            'tepitope_predictor_data_2016-01-29.p',
        ],
    },
    description='PyPA package for mhcii tepitope analyses.',
    long_description=README,
    # Important only if the package will be widely distributed.  See more at:
    #    https://pypi.python.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 2',
    ]
)
