'''
Created on Oct 2, 2019
@author: Yan
The code coverage by tests is 92%. (netmhcii_11_python_interface.py)  
'''
from unittest import TestCase
import unittest
from netmhcii_11_executable import single_prediction

'''
$ coverage report
Name                                                                                                          Stmts   Miss  Cover
---------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/comblib_sidney2008_predictor_data/__init__.py          0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/comblib_sidney2008_predictor_data/data_access.py      19     11    42%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                           1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                      0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py          10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py            3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py            12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py        41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py        281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py           150     78    48%
netmhcii_11_executable/__init__.py                                                                                1      0   100%
netmhcii_11_executable/netmhcii_11_python_interface.py                                                           61      5    92%
tests.py                                                                                                         26      0   100%
---------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                          2211   1301    41%
'''

class TestNetMHCII11(TestCase):

    def test_HLA_prediction(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 16)
        expected_result = [[('ASSSSAAAA', 14800.0)]]
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'H2-IAb', 15)
        expected_result = [[('SASSSSAAA', 280.0), ('SSAAAAAAA', 259.0)]]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'H2-IAb', 10)
        expected_result = [[('ASSASSSSA', 767.0), ('SSASSSSAA', 724.0), ('SASSSSAAA', 1559.0), ('ASSSSAAAA', 1873.0), ('SSSSAAAAA', 2136.0), ('SSSAAAAAA', 1182.0), ('SSAAAAAAA', 929.0)]]
        self.assertEqual(result, expected_result)

    def test_sequence_list(self):
        result = single_prediction('sequence_list', 'H2-IAb', 10, ['GHAHKVPRRLLKAAR', 'LKAADASADADGSGSGSGSG'])
        expected_result = [[('GHAHKVPRR', 44526.0), ('HAHKVPRRL', 50000.0), ('AHKVPRRLL', 50000.0), ('HKVPRRLLK', 35328.0), ('KVPRRLLKA', 31326.0), ('VPRRLLKAA', 50000.0)], [('LKAADASAD', 4557.0), ('KAADASADA', 29558.0), ('AADASADAD', 50000.0), ('ADASADADG', 50000.0), ('DASADADGS', 50000.0), ('ASADADGSG', 50000.0), ('SADADGSGS', 50000.0), ('ADADGSGSG', 50000.0), ('DADGSGSGS', 50000.0), ('ADGSGSGSG', 50000.0), ('DGSGSGSGS', 46606.0)]]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)


if __name__ == '__main__':
    unittest.main()
