'''
netmhcii_23_executable is for SMM 2.3
'''
import tempfile
import re
import logging
import itertools
import os
from subprocess import Popen, PIPE
from pkg_resources import resource_filename  # @UnresolvedImport
logger = logging.getLogger(__name__)

# --- The following sets up a variable 'EXECUTABLE_PATH' which holds the
#    full path to the NetMHCII executable.

# The name of the package this file is a part of.
PACKAGE_NAME = 'netmhcii_23_executable'
# The NetMHCII executable name.
EXECUTABLE_NAME = 'netMHCII-2.3'
# Absolute path to the directory this package is installed in.
PACKAGE_DIR = os.path.normpath(os.path.join(__file__, os.path.pardir))
# Relative path to the executable
EXECUTABLE_RELPATH = resource_filename(PACKAGE_NAME, EXECUTABLE_NAME)
# Absolute path to the executable
EXECUTABLE_PATH = os.path.normpath(os.path.join(PACKAGE_DIR, EXECUTABLE_RELPATH))

def single_prediction(sequence, allele, length=15):
    ic50s = []

    infile = tempfile.NamedTemporaryFile(prefix='nnalign_input_', mode='w')
    infile.write(">test\n" + sequence + "\n")

    # allele format DR: DRB1_0101; DQ: HLA-DQA10201-DQB10301; DP: HLA-DPA10103-DPB10601; H2: H-2-IAb
    if re.compile("H2").match(allele):
        allele = allele.replace('H2', 'H-2')
    elif "DRB" in allele:
        allele = allele.replace('HLA-', '').replace('*', '_').replace(':', '')
    elif "DQ" in allele or "DP" in allele:
        allele = allele.replace('*', '').replace(':', '')
        if "HLA-" not in allele:
            allele = "HLA-" + allele

    infile.seek(0)
    
    length = str(int(length))

    #retcode = os.spawnl (os.P_WAIT, EXECUTABLE_PATH, "netMHCII-2.3", "-a", allele, infile.name, ">", outfile.name)
    cmd = [EXECUTABLE_PATH, "-a", allele, "-l", length, infile.name,]
    process = Popen(cmd, stdout=PIPE)
    stdoutdata, stderrdata_ignored = process.communicate()

    logger.debug('Raw output:\n%s', stdoutdata)

    # for python 3
    stdoutdata = stdoutdata.decode()
    lines = stdoutdata.split('\n')

    all_lists = []
    newlist = [list(g) for k, g in itertools.groupby(lines, lambda x: re.match('-', x)) if not k]

    i = 2
    while i < len(newlist):
        all_lists.append(newlist[i])
        i = i + 3

    check_list = []
    for i in range(len(all_lists)):
        ic50s = []
        for l in all_lists[i]:
            mynewlist = l.split()
            allele = mynewlist[0]
            score = float(mynewlist[6])
            core = mynewlist[3]
            temp_list = (core, score)
            ic50s.append(temp_list)
        check_list.append(ic50s)

    return(check_list)
