import os
from setuptools import setup

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

# --- Get all of the NetMHCII executable's support files for package_data
def recursive_walk(startdir):
    file_list = []
    for dirname, subdirList, fileList in os.walk(startdir, followlinks=True):
        for fname in fileList:
            file_list.append(os.path.join(dirname, fname))
            for sdname in subdirList:
                sdfiles = recursive_walk(sdname)
                file_list.extend(sdfiles)
    return file_list

pkg_data_files = ['netMHCII-2.3']
os.chdir('netmhcii_23_executable')
for subdir in ['Linux_x86_64', 'data', 'test']:
    file_list = recursive_walk(subdir)
    pkg_data_files.extend(file_list)
os.chdir(os.pardir)


with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as readme:
    README = readme.read()

setup(
    name="netmhcii-2.3-executable",
    version="1.0.2",
    packages=['netmhcii_23_executable' ],
    package_data={ 'netmhcii_23_executable': pkg_data_files },
    test_suite = 'tests',
    description='Python package to provide netmhcii 2.3 executable',
    long_description=README,
    classifiers=[
        'Intended Audience :: Developers',
        'Operating System :: POSIX :: Linux',
        'Programming Language :: Python :: 3',
    ]
)
