'''
Created on Oct 2, 2019
@author: Yan
The code coverage by tests is 100%. (netmhcii_23_python_interface.py)  
'''
from unittest import TestCase
import unittest
from netmhcii_23_executable import single_prediction

'''
$ coverage report
Name                                                                                                        Stmts   Miss  Cover
-------------------------------------------------------------------------------------------------------------------------------
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/__init__.py                         1607    988    39%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/__init__.py                    0      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__about__.py        10      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/__init__.py          3      0   100%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_compat.py          12      1    92%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/_structures.py      41     17    59%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/specifiers.py      281    201    28%
/home/jyan/.virtualenvs/gitlab/lib/python2.7/site-packages/pkg_resources/_vendor/packaging/version.py         150     78    48%
netmhcii_23_executable/__init__.py                                                                              1      0   100%
netmhcii_23_executable/netmhcii_23_python_interface.py                                                         45      0   100%
tests.py                                                                                                       21      0   100%
-------------------------------------------------------------------------------------------------------------------------------
TOTAL                                                                                                        2171   1285    41%

'''

class TestNetMHCII11(TestCase):

    def test_HLA_prediction(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 16)
        expected_result = [[('ASSSSAAAA', 24499.5)]]
        self.assertEqual(result, expected_result)

    def test_H2_prediction(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'H2-IAb', 15)
        expected_result = [[('SSSSAAAAA', 33.5), ('SSAAAAAAA', 27.9)]]
        self.assertEqual(result, expected_result)

    def test_length(self):
        result = single_prediction('ASSASSSSAAAAAAAT', 'H2-IAb', 10)
        expected_result = [[('SSASSSSAA', 998.5), ('SASSSSAAA', 938.1), ('ASSSSAAAA', 700.7), ('SSSSAAAAA', 727.4), ('SSSAAAAAA', 493.1), ('SSAAAAAAA', 232.8), ('SAAAAAAAT', 211.1)]]
        self.assertEqual(result, expected_result)

    def test_ValueError(self):
        with self.assertRaises(ValueError):
            result = single_prediction('ASSASSSSAAAAAAAT', 'DRB1*13:02', 20)


if __name__ == '__main__':
    unittest.main()
