from allele_info import MHCIIAlleleData


def close_cells(rows):
    # to use | to close cells for all rows and let the length equal
    max_width = max(map(len, rows))
    if max_width == 0:
        raise(ValueError('max_width == 0'))

    for i in range(len(rows)):
        row = rows[i]
        if len(row) == max_width and row[-1] == '|':
            rows[i] = row[:-1]+' '+row[-1]
        else:
            if row[-1] == '|':
                row += ' '
            rows[i] = row+(row[-1]*(max_width-len(row)))+'|'

    return rows

def get_available_alleles(methods, default_rows_number = 15):

    # 1. get method alleles_info dict 
    miiad = MHCIIAlleleData()
    method_alleles_dict = dict()
    
    for method in methods:
        printed_alleles = []
        alleles = miiad.get_allele_names(method.replace('consensus3', 'consensus').replace('sturniolo', 'tepitope').replace('nn_align', 'nn_align-2.3'))
        # group alleles and add "HLA-" to DRB, DP, and DQ alleles
        dq_dp_alleles = ['HLA-'+a for a in alleles if 'DQ' in a or 'DP' in a]
        other_alleles = [a.replace('DRB', 'HLA-DRB') for a in alleles if 'DQ' not in a and 'DP' not in a]

        # 1.1 initialize
        
        for allele in dq_dp_alleles:
            printed_alleles.append('| %s ' % allele)

        if not printed_alleles:
            printed_alleles = ['|', ] * default_rows_number
        else:
            printed_alleles = close_cells(printed_alleles)

        # 1.2 for DRB and H2
        row_index = 0
        rows_number = len(printed_alleles)
        for allele in other_alleles:
            printed_alleles[row_index] += ' %s ' % allele
            row_index += 1
            if row_index >= rows_number:
                printed_alleles = close_cells(printed_alleles)
                row_index = 0

        if row_index != 0:
            printed_alleles = close_cells(printed_alleles)
        
        method_alleles_dict[method] =  printed_alleles 
    

    # 2. add method name to each section
    printed_alleles_combined = []
    for  method in methods:
        printed_alleles = method_alleles_dict[method]
        printed_alleles_combined.append('| Alleles available for %s method: ' % method)
        printed_alleles_combined.append('|-')
        printed_alleles_combined.extend(printed_alleles)
        printed_alleles_combined.append('|-')

    # 3. add allele info for section 'netmhciipan'
    printed_alleles_combined.extend([
'| Alleles available for NetMHCIIpan (netmhciipan_ba, netmhciipan_el) method: ',
'|-', 
'|  Please see the NetMHCIIpan webserver for information on the  ',
'|  more than 500 alleles available: ',
'|  http://www.cbs.dtu.dk/services/NetMHCIIpan/    ',
'|-', ])

    printed_alleles_combined = close_cells(printed_alleles_combined)

    # add === to the top
    printed_alleles_combined.insert(0, ' %s ' % ('='*(max(map(len, printed_alleles_combined))-2)))

    return '\n'.join(printed_alleles_combined)


def main():
    looking_up_methods = ['consensus3', 'comblib', 'smm_align', 'nn_align', 'sturniolo']
    allele_info_for_printing = get_available_alleles(looking_up_methods)

    print(allele_info_for_printing)

